<!DOCTYPE html>
<html lang="en">
 <!-- head area start -->
    <?php include 'layout/partials/head.php'?>
 <!-- head area end -->
<body class="page-template template-resell">
    <!-- HEADER AREA START-->
        <?php include 'layout/header/header-one.php';?>
    <!-- HEADER AREA END -->

    <!-- HERO BANNER ONE -->
    <section class="rts-hero-three rts-hosting-banner rts-hero__one domain-checker-padding banner-default-height">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-lg-12">
                    <div class="rts-hero__content domain">
                        <h1 data-sal="slide-down" data-sal-delay="100" data-sal-duration="800">We Made Domain Transfer Easy</h1>
                        <p class="description" data-sal="slide-down" data-sal-delay="200" data-sal-duration="800">Enter the domain that you would like to transfer to Hostie</p>

                        <form action="https://hostie-whmcs.themewant.com/cart.php" class="domain-form d-flex gap-3">
                            <input type="hidden" name="domain" value="register">
                            <input type="hidden" name="a" value="add">
                            <input type="text" placeholder="Enter the domain you want to transfer" name="query" required>
                            <button class="submit-btn" type="submit" name="domain_type">Transfer</button>
                        </form>
                        <div class="banner-content-tag">
                            <p class="desc" data-sal-delay="400" data-sal-duration="800">Looking for a new domain name? <a href="domain-checker.php">Try domain checker</a></p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="banner-shape-area">
            <img class="three" src="assets/images/banner/banner-bg-element.svg" alt="">
        </div>
    </section>
    <!-- HERO BANNER ONE END -->

    <!-- SERVICES -->
    <div class="rts-domain-service section__padding">
        <div class="container">
            <div class="row justify-content-center">
                <div class="rts-section w-650 text-center">
                    <h2 class="rts-section__title  mb-0" data-sal="slide-down" data-sal-delay="100" data-sal-duration="800">
                        4 reasons to use our domain
                        transfer service</h2>
                </div>
            </div>
            <!-- content -->
            <div class="row g-30">
                <div class="col-xl-3 col-lg-4 col-md-6 col-sm-6">
                    <div class="card-feature">
                        <div class="card-feature__single">
                            <div class="card-feature__single--icon">
                                <svg width="40" height="40" viewBox="0 0 40 40" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path d="M34.1172 4.65781H30.5008V2.35C30.5008 1.05469 29.4469 0 28.1508 0C26.8547 0 25.8008 1.05391 25.8008 2.35V4.65781H14.2016V2.35C14.2016 1.05469 13.1484 0 11.8539 0C10.5586 0 9.50391 1.05391 9.50391 2.35V4.65781H5.88594C3.26328 4.65781 1.12891 6.79141 1.12891 9.41484V35.243C1.12891 37.8656 3.2625 40 5.88594 40H34.1172C36.7398 40 38.8742 37.8664 38.8742 35.243V9.41406C38.8742 6.79141 36.7398 4.65781 34.1172 4.65781ZM27.0508 2.35C27.0508 1.74297 27.5445 1.24922 28.1516 1.24922C28.7586 1.24922 29.2523 1.74297 29.2523 2.35V8.21406C29.2523 8.82109 28.7586 9.31484 28.1516 9.31484C27.5445 9.31484 27.0508 8.82109 27.0508 8.21406V2.35ZM10.7539 2.35C10.7539 1.74297 11.2477 1.24922 11.8547 1.24922C12.4602 1.24922 12.9531 1.74297 12.9531 2.35V8.21406C12.9531 8.82109 12.4602 9.31484 11.8547 9.31484C11.2477 9.31484 10.7539 8.82109 10.7539 8.21406V2.35ZM5.88594 5.90625H9.50469V8.21406C9.50469 9.50937 10.5586 10.5641 11.8547 10.5641C13.1492 10.5641 14.2023 9.51016 14.2023 8.21406V5.90625H25.8023V8.21406C25.8023 9.50937 26.8563 10.5641 28.1523 10.5641C29.4484 10.5641 30.5023 9.51016 30.5023 8.21406V5.90625H34.1188C36.0531 5.90625 37.6266 7.47969 37.6266 9.41406V13.4531H2.37813V9.41406C2.37813 7.48047 3.95156 5.90625 5.88594 5.90625ZM34.1172 38.7508H5.88594C3.95156 38.7508 2.37813 37.1773 2.37813 35.243V14.7031H37.625V35.243C37.625 37.1773 36.0516 38.7508 34.1172 38.7508ZM9.50703 19.482H7.60625C6.60156 19.482 5.78359 20.3 5.78359 21.3047V23.2047C5.78359 24.2094 6.60156 25.0273 7.60625 25.0273H9.50625C10.5109 25.0273 11.3289 24.2094 11.3289 23.2047V21.3047C11.3297 20.2992 10.5117 19.482 9.50703 19.482ZM10.0805 23.2047C10.0805 23.5211 9.82344 23.7781 9.50703 23.7781H7.60625C7.29531 23.7781 7.03281 23.5156 7.03281 23.2047V21.3047C7.03281 20.9883 7.28984 20.7312 7.60625 20.7312H9.50625C9.82266 20.7312 10.0797 20.9883 10.0797 21.3047V23.2047H10.0805ZM20.9516 19.482H19.0539C18.0477 19.482 17.2289 20.3 17.2289 21.3047V23.2047C17.2289 24.2094 18.0477 25.0273 19.0539 25.0273H20.9516C21.9563 25.0273 22.7742 24.2094 22.7742 23.2047V21.3047C22.7742 20.2992 21.9563 19.482 20.9516 19.482ZM21.525 23.2047C21.525 23.5211 21.268 23.7781 20.9516 23.7781H19.0539C18.7414 23.7781 18.4781 23.5156 18.4781 23.2047V21.3047C18.4781 20.9883 18.7367 20.7312 19.0539 20.7312H20.9516C21.268 20.7312 21.525 20.9883 21.525 21.3047V23.2047ZM32.3969 19.482H30.4992C29.493 19.482 28.6742 20.3 28.6742 21.3047V23.2047C28.6742 24.2094 29.493 25.0273 30.4992 25.0273H32.3969C33.4031 25.0273 34.2219 24.2094 34.2219 23.2047V21.3047C34.2211 20.2992 33.4023 19.482 32.3969 19.482ZM32.9727 23.2047C32.9727 23.5156 32.7086 23.7781 32.3969 23.7781H30.4992C30.1867 23.7781 29.9234 23.5156 29.9234 23.2047V21.3047C29.9234 20.9883 30.182 20.7312 30.4992 20.7312H32.3969C32.7141 20.7312 32.9727 20.9883 32.9727 21.3047V23.2047ZM9.50703 28.4266H7.60625C6.60156 28.4266 5.78359 29.2453 5.78359 30.2516V32.1492C5.78359 33.1539 6.60156 33.9719 7.60625 33.9719H9.50625C10.5109 33.9719 11.3289 33.1539 11.3289 32.1492V30.2516C11.3297 29.2453 10.5117 28.4266 9.50703 28.4266ZM10.0805 32.1492C10.0805 32.4656 9.82344 32.7227 9.50703 32.7227H7.60625C7.28984 32.7227 7.03281 32.4656 7.03281 32.1492V30.2516C7.03281 29.9391 7.29531 29.6758 7.60625 29.6758H9.50625C9.82266 29.6758 10.0797 29.9344 10.0797 30.2516V32.1492H10.0805ZM20.9516 28.4266H19.0539C18.0477 28.4266 17.2289 29.2453 17.2289 30.2516V32.1492C17.2289 33.1539 18.0477 33.9719 19.0539 33.9719H20.9516C21.9563 33.9719 22.7742 33.1539 22.7742 32.1492V30.2516C22.7742 29.2453 21.9563 28.4266 20.9516 28.4266ZM21.525 32.1492C21.525 32.4656 21.268 32.7227 20.9516 32.7227H19.0539C18.7367 32.7227 18.4781 32.4656 18.4781 32.1492V30.2516C18.4781 29.9344 18.7367 29.6758 19.0539 29.6758H20.9516C21.268 29.6758 21.525 29.9344 21.525 30.2516V32.1492ZM32.3969 28.4266H30.4992C29.493 28.4266 28.6742 29.2453 28.6742 30.2516V32.1492C28.6742 33.1539 29.493 33.9719 30.4992 33.9719H32.3969C33.4031 33.9719 34.2219 33.1539 34.2219 32.1492V30.2516C34.2211 29.2453 33.4023 28.4266 32.3969 28.4266ZM32.9727 32.1492C32.9727 32.4656 32.7141 32.7227 32.3969 32.7227H30.4992C30.182 32.7227 29.9234 32.4656 29.9234 32.1492V30.2516C29.9234 29.9344 30.182 29.6758 30.4992 29.6758H32.3969C32.7141 29.6758 32.9727 29.9344 32.9727 30.2516V32.1492Z" fill="white" />
                                </svg>
                            </div>
                            <h5 class="card-feature__single--title">
                                No Time Lost
                            </h5>
                            <p class="card-feature__single--description">
                                We guarantee it you don't have
                                to worry about it.
                            </p>
                        </div>
                    </div>
                </div>
                <div class="col-xl-3 col-lg-4 col-md-6 col-sm-6">
                    <div class="card-feature">
                        <div class="card-feature__single">
                            <div class="card-feature__single--icon">
                                <svg width="40" height="40" viewBox="0 0 40 40" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <g clip-path="url(#clip0_845_2111)">
                                        <path d="M30.5446 34.377C30.1473 34.5935 29.7444 34.817 29.3364 35.0431C25.8841 36.9572 21.9713 39.1267 18.2105 38.7909L4.89242 37.602C4.87508 37.6004 4.85766 37.5996 4.84023 37.5996H1.17414V31.0088H4.84016C4.97898 31.0088 5.11336 30.9595 5.2193 30.8699C5.22969 30.8612 6.27883 29.9797 7.87602 29.15C8.16375 29.0006 8.27578 28.6461 8.12641 28.3584C7.97687 28.0707 7.62258 27.9585 7.33477 28.1081C5.98805 28.8077 5.01109 29.5362 4.6325 29.8346H0.587109C0.262891 29.8346 0 30.0975 0 30.4217V38.1867C0 38.5109 0.262812 38.7738 0.587109 38.7738H4.81398L18.1061 39.9605C18.4063 39.9873 18.7059 40.0001 19.0055 40.0001C22.8173 40.0001 26.5682 37.9206 29.9057 36.0702C30.3112 35.8454 30.7116 35.6234 31.1064 35.4081C31.3911 35.253 31.4962 34.8964 31.341 34.6117C31.1859 34.3269 30.8295 34.2219 30.5446 34.377Z" fill="#2D3C58" />
                                        <path d="M39.545 27.874C38.9208 27.0466 37.8332 26.7608 36.8946 27.1538C36.8706 26.7783 36.7435 26.4125 36.5208 26.1008C35.9338 25.279 34.8178 25.0142 33.9249 25.4849L32.5286 26.2207C32.5107 25.8928 32.414 25.5702 32.2416 25.2852C31.6846 24.3644 30.5074 24.0446 29.5617 24.5572L28.5182 25.123C28.4993 24.7173 28.3619 24.3218 28.1167 23.988C27.5047 23.1552 26.3967 22.8991 25.4821 23.3788L17.9479 27.3304C17.1007 27.0051 14.3997 26.1253 11.244 26.7128C10.6996 26.8142 10.1388 26.9608 9.5769 27.1487C9.2694 27.2515 9.10346 27.5841 9.2062 27.8916C9.30909 28.1991 9.64182 28.3649 9.94917 28.2623C10.4598 28.0916 10.9677 27.9587 11.4589 27.8672C14.8276 27.2399 17.7105 28.5001 17.7384 28.5125C17.8141 28.5465 17.896 28.5641 17.979 28.5641H25.8212C26.3784 28.5641 26.8317 29.0187 26.8317 29.5774C26.8317 30.0867 26.4517 30.5189 25.9478 30.5827L16.0084 31.8416C15.7143 31.8789 15.4942 32.1295 15.4951 32.4258C15.496 32.7222 15.7177 32.9714 16.0119 33.0069L20.2332 33.5157C24.3224 34.0084 28.3871 33.2109 31.9882 31.209L37.2632 28.2766C37.7273 28.0348 38.2918 28.1624 38.6076 28.5811C39.0021 29.0791 38.8307 29.8777 38.2657 30.1685L32.6057 33.2529C31.929 33.6085 32.509 34.6588 33.1676 34.2839L38.8275 31.1995C39.4011 30.887 39.8092 30.3413 39.9474 29.7022C40.0856 29.0625 39.9389 28.3962 39.545 27.874ZM26.0275 24.4186C26.4242 24.2106 26.9049 24.3218 27.1706 24.6833C27.497 25.1042 27.3488 25.772 26.8742 26.0142L24.3367 27.3899H20.3624L26.0275 24.4186ZM26.5615 27.5194L30.1214 25.5894C30.515 25.376 31.0049 25.5095 31.237 25.8931C31.4899 26.2902 31.3316 26.8638 30.9101 27.0738L27.8224 28.7011C27.5826 28.1541 27.1259 27.7235 26.5615 27.5194ZM31.4177 30.1827C28.1885 31.9779 24.5625 32.7425 20.8989 32.4057L26.0954 31.7475C27.0595 31.6255 27.8132 30.8803 27.9738 29.9485L34.4723 26.5235C34.8481 26.3255 35.318 26.437 35.5653 26.7832C35.8648 27.1811 35.7257 27.802 35.2845 28.0331L31.4177 30.1827Z" fill="#2D3C58" />
                                        <path d="M13.6728 15.9519C14.3359 15.9519 14.9737 15.8084 15.5686 15.5255C15.8614 15.3863 15.9859 15.036 15.8466 14.7432C15.7074 14.4505 15.3573 14.3258 15.0643 14.4651C14.6283 14.6725 14.1601 14.7776 13.6728 14.7776C11.8837 14.7776 10.428 13.322 10.428 11.5329C10.428 9.74374 11.8837 8.28819 13.6728 8.28819C15.462 8.28819 16.9176 9.74374 16.9176 11.5329C16.9176 12.0807 16.7787 12.6219 16.5159 13.098C16.3593 13.3819 16.4623 13.739 16.7462 13.8956C17.0302 14.0523 17.3873 13.9491 17.5439 13.6653C17.9023 13.0159 18.0917 12.2786 18.0917 11.5328C18.0917 9.09616 16.1094 7.11389 13.6728 7.11389C11.2362 7.11389 9.25391 9.09616 9.25391 11.5328C9.25391 13.9694 11.2362 15.9519 13.6728 15.9519Z" fill="#2D3C58" />
                                        <path d="M4.50453 13.2784L5.72133 13.4613C5.92 14.2856 6.24352 15.0664 6.6868 15.7909L5.95531 16.7812C5.60969 17.2491 5.65742 17.8873 6.06883 18.2985L6.90648 19.1362C7.31781 19.5476 7.95602 19.5953 8.42391 19.2497L9.41406 18.5183C10.1386 18.9616 10.9193 19.2852 11.7437 19.4838L11.9266 20.7006C12.0131 21.2759 12.4981 21.6934 13.0798 21.6934H14.2644C14.8461 21.6934 15.3311 21.2759 15.4175 20.7005L15.6004 19.4838C16.4248 19.2852 17.2055 18.9616 17.93 18.5183L18.9202 19.2498C19.3881 19.5953 20.0263 19.5477 20.4376 19.1363L21.2752 18.2987C21.6866 17.8874 21.7344 17.2492 21.3888 16.7812L20.6573 15.7911C21.1006 15.0666 21.4242 14.2859 21.6228 13.4615L22.8395 13.2786C23.4148 13.1921 23.8323 12.7072 23.8323 12.1254V12.1201H27.3164V19.603C27.3164 20.358 27.9306 20.9722 28.6855 20.9722H31.1937C31.4622 22.1689 32.5325 23.066 33.8091 23.066C35.2873 23.066 36.4901 21.8634 36.4901 20.385C36.4901 18.9067 35.2874 17.704 33.8091 17.704C32.5324 17.704 31.4621 18.6012 31.1936 19.798H28.6855C28.578 19.798 28.4905 19.7105 28.4905 19.603V12.1201H31.1936C31.4621 13.3169 32.5324 14.2141 33.8091 14.2141C35.2873 14.2141 36.4901 13.0114 36.4901 11.533C36.4901 10.0547 35.2874 8.85203 33.8091 8.85203C32.5325 8.85203 31.4622 9.74914 31.1936 10.9459H28.4907V3.46305C28.4907 3.35555 28.5781 3.26813 28.6856 3.26813H31.1938C31.4623 4.46492 32.5326 5.36203 33.8092 5.36203C35.2875 5.36203 36.4902 4.15938 36.4902 2.68102C36.4902 1.20266 35.2874 0 33.8091 0C32.5326 0 31.4623 0.897109 31.1937 2.09391H28.6855C27.9306 2.09391 27.3164 2.70805 27.3164 3.46297V10.9458H23.8323V10.9406C23.8323 10.359 23.4148 9.87398 22.8396 9.7875L21.6228 9.60461C21.4241 8.78023 21.1006 7.99953 20.6573 7.275L21.3888 6.28484C21.7344 5.81687 21.6867 5.17867 21.2753 4.76742L20.4377 3.92969C20.0264 3.51836 19.3882 3.4707 18.9202 3.81625L17.9301 4.54766C17.2055 4.10437 16.4248 3.78078 15.6005 3.58219L15.4176 2.36539C15.3312 1.79016 14.8462 1.37258 14.2645 1.37258H13.0798C12.4981 1.37258 12.0131 1.79008 11.9266 2.36539L11.7437 3.58219C10.9194 3.78086 10.1387 4.10437 9.41406 4.54766L8.42391 3.81625C7.95609 3.47062 7.31781 3.51828 6.90648 3.92969L6.06883 4.76727C5.65742 5.17859 5.60969 5.8168 5.95531 6.28469L6.68672 7.27484C6.24344 7.99937 5.91984 8.78016 5.72125 9.60445L4.50445 9.78734C3.92922 9.87383 3.51172 10.3588 3.51172 10.9405V12.1251C3.51172 12.707 3.9293 13.192 4.50453 13.2784ZM33.8091 18.878C34.64 18.878 35.3159 19.554 35.3159 20.3848C35.3159 21.2157 34.64 21.8916 33.8091 21.8916C32.9783 21.8916 32.3023 21.2157 32.3023 20.3848C32.3023 19.554 32.9783 18.878 33.8091 18.878ZM33.8091 10.0261C34.64 10.0261 35.3159 10.702 35.3159 11.5329C35.3159 12.3638 34.64 13.0397 33.8091 13.0397C32.9783 13.0397 32.3023 12.3638 32.3023 11.5329C32.3023 10.702 32.9783 10.0261 33.8091 10.0261ZM33.8091 1.17414C34.64 1.17414 35.3159 1.85008 35.3159 2.68094C35.3159 3.5118 34.64 4.18773 33.8091 4.18773C32.9783 4.18773 32.3023 3.5118 32.3023 2.68094C32.3023 1.85016 32.9783 1.17414 33.8091 1.17414ZM4.68586 10.9475L6.29734 10.7052C6.54453 10.6681 6.74109 10.4785 6.78711 10.2329C6.96602 9.27875 7.33539 8.38758 7.88477 7.58406C8.02578 7.37781 8.02086 7.10484 7.87234 6.90383L6.90391 5.59266L7.7318 4.76484L9.04297 5.73336C9.24391 5.8818 9.5168 5.8868 9.72312 5.74578C10.5267 5.19633 11.4179 4.82703 12.372 4.64805C12.6176 4.60203 12.8071 4.40547 12.8443 4.15828L13.0866 2.5468H14.2573L14.4996 4.15828C14.5368 4.40547 14.7263 4.60203 14.972 4.64805C15.926 4.82695 16.8173 5.19633 17.6208 5.74578C17.8271 5.88687 18.1 5.8818 18.301 5.73336L19.6122 4.76484L20.4401 5.59266L19.4716 6.90391C19.3232 7.10484 19.3182 7.37781 19.4592 7.58414C20.0087 8.38766 20.378 9.27883 20.557 10.233C20.603 10.4787 20.7996 10.6682 21.0467 10.7054L22.6582 10.9477V12.1184L21.0467 12.3607C20.7996 12.3978 20.603 12.5874 20.557 12.833C20.378 13.7873 20.0087 14.6784 19.4592 15.482C19.3182 15.6882 19.3231 15.9612 19.4716 16.1621L20.4402 17.4733L19.6123 18.3012L18.3011 17.3327C18.1002 17.1842 17.8272 17.1792 17.6209 17.3203C16.8173 17.8698 15.9262 18.2391 14.972 18.418C14.7263 18.4641 14.5368 18.6607 14.4996 18.9078L14.2573 20.5193H13.0866L12.8443 18.9078C12.8071 18.6607 12.6176 18.4641 12.372 18.418C11.4177 18.2391 10.5266 17.8698 9.72305 17.3203C9.5168 17.1793 9.24391 17.1842 9.04289 17.3327L7.73172 18.3012L6.90383 17.4733L7.87234 16.1621C8.02078 15.9612 8.02578 15.6881 7.88477 15.482C7.33531 14.6784 6.96602 13.7873 6.78711 12.8331C6.74102 12.5875 6.54453 12.3979 6.29734 12.3608L4.68586 12.1185V10.9475Z" fill="#2D3C58" />
                                    </g>
                                    <defs>
                                        <clipPath id="clip0_845_2111">
                                            <rect width="40" height="40" fill="white" />
                                        </clipPath>
                                    </defs>
                                </svg>
                            </div>
                            <h5 class="card-feature__single--title">
                                Domain Management
                            </h5>
                            <p class="card-feature__single--description">
                                Hostinger offers a wide variety
                                tools to satisfy advanced user
                            </p>
                        </div>
                    </div>
                </div>
                <div class="col-xl-3 col-lg-4 col-md-6 col-sm-6">
                    <div class="card-feature">
                        <div class="card-feature__single">
                            <div class="card-feature__single--icon">
                                <svg width="40" height="40" viewBox="0 0 40 40" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path d="M38.2346 28.7647C38.5875 28.7647 38.8228 28.5294 38.8228 28.1765V23.9412C38.8228 22.6471 37.764 21.5882 36.4699 21.5882H20.8817C20.1758 21.5882 19.4699 21.9412 19.0581 22.4706C18.6464 22.1177 18.117 21.5294 17.8817 21C19.2934 20.1765 20.4111 18.8824 21.0581 17.353C21.3523 17.6471 21.7052 17.7647 22.117 17.7647C22.9405 17.7647 23.6464 17.1177 23.7052 16.2353C25.2934 16.1177 26.4111 14.8235 26.4111 13.353C26.4111 11.8824 25.3523 10.5882 23.7052 10.4118V8.88237C23.7052 4.58825 20.2346 1.05884 15.8817 1.05884H11.8228C7.52872 1.05884 3.99931 4.52943 3.99931 8.88237V10.4118C2.4699 10.5294 1.29343 11.8235 1.29343 13.353C1.29343 14.8824 2.41108 16.1177 3.99931 16.2353C4.05813 17.0588 4.76402 17.7647 5.58755 17.7647C5.94049 17.7647 6.29343 17.6471 6.58755 17.4118C7.29343 18.9412 8.41108 20.2353 9.76402 21C9.52872 21.5882 8.88166 22.2353 8.4699 22.5882C4.52872 22.8235 1.17578 26.2941 1.17578 30.4706V37.4706C1.17578 38.2353 1.76402 38.8235 2.52872 38.8235H11.2934C11.6464 38.8235 11.8817 38.5882 11.8817 38.2353C11.8817 37.8824 11.6464 37.6471 11.2934 37.6471H7.82284V31C7.82284 30.6471 7.58755 30.4118 7.23461 30.4118C6.88166 30.4118 6.64637 30.6471 6.64637 31V37.7059H2.52872C2.41108 37.7059 2.35225 37.6471 2.35225 37.5294V30.4706C2.35225 26.9412 5.17578 24 8.64637 23.7647L13.5287 28.7059C13.764 28.9412 14.117 28.9412 14.3523 28.7059L18.5287 24.4706V34.9412H15.4111C14.4699 34.9412 13.6464 35.7059 13.6464 36.7059V38.2941C13.6464 38.6471 13.8817 38.8824 14.2346 38.8824H38.2346C38.5875 38.8824 38.8228 38.6471 38.8228 38.2941C38.8228 36.7059 38.8228 33.7647 38.8228 32.2353C38.8228 31.8824 38.5875 31.6471 38.2346 31.6471C37.8817 31.6471 37.6464 31.8824 37.6464 32.2353V35H19.7052V23.9412C19.7052 23.2941 20.2346 22.7647 20.8817 22.7647H36.4699C37.117 22.7647 37.6464 23.2941 37.6464 23.9412V28.1765C37.6464 28.5294 37.8817 28.7647 38.2346 28.7647ZM37.6464 36.1177V37.6471C36.117 37.6471 44.4699 37.6471 14.8228 37.6471V36.6471C14.8228 36.353 15.0581 36.0588 15.4111 36.0588C23.4111 36.1177 29.2934 36.1177 37.6464 36.1177ZM7.35225 10.8235C7.35225 7.4706 9.58755 5.7059 11.9993 5.7059H15.8817C18.2346 5.7059 20.1758 7.4706 20.5287 9.7059C19.4699 10.7647 18.4699 11.2353 17.5287 11.1177C15.8817 10.8824 14.764 8.88237 14.764 8.82354C14.6464 8.58825 14.4111 8.52943 14.1758 8.52943C13.9405 8.52943 13.764 8.7059 13.6464 8.94119C13.5875 9.11766 11.9993 13.4118 7.35225 12.1765V10.8235ZM22.2346 16.6471C21.9993 16.6471 21.8228 16.4706 21.8228 16.2353V10.8824C21.8228 10.6471 21.9993 10.4706 22.2346 10.4706C22.4699 10.4706 22.6464 10.6471 22.6464 10.8824V16.2353C22.6464 16.4118 22.4699 16.6471 22.2346 16.6471ZM25.3523 13.353C25.3523 14.2353 24.7052 15 23.8228 15.1177C23.8228 15.0588 23.8228 11.5294 23.8228 11.6471C24.7052 11.7647 25.3523 12.4706 25.3523 13.353ZM11.9993 2.29413H16.0581C19.7052 2.29413 22.7052 5.29413 22.7052 8.94119V9.29413C22.3523 9.17648 22.0581 9.17648 21.7052 9.35295C21.1758 6.64707 18.764 4.52943 15.9405 4.52943H12.0581C9.17578 4.52943 6.82284 6.58825 6.29343 9.29413C5.94049 9.17648 5.70519 9.17648 5.41108 9.29413V8.94119C5.35225 5.29413 8.35225 2.29413 11.9993 2.29413ZM2.64637 13.353C2.64637 12.4706 3.29343 11.7059 4.17578 11.5883V15.1177C3.29343 15 2.64637 14.2353 2.64637 13.353ZM5.82284 16.6471C5.58755 16.6471 5.41108 16.4706 5.41108 16.2353C5.41108 16.1765 5.41108 10.7059 5.41108 10.7647C5.4699 10.5882 5.58755 10.4706 5.76402 10.4706C5.94049 10.4706 6.05813 10.5294 6.17578 10.6471C6.17578 10.8824 6.29343 16.5882 6.29343 16.2353C6.2346 16.4118 6.05813 16.6471 5.82284 16.6471ZM7.41108 15.6471V13.353C7.99931 13.4706 8.4699 13.5294 8.99931 13.5294C11.9405 13.5294 13.5875 11.4706 14.3523 10.2353C14.9405 11 15.9993 12 17.3523 12.2353C18.4699 12.4118 19.5287 12.0588 20.6464 11.1765C20.6464 11.2353 20.6464 15.4706 20.6464 15.1765H17.5875C17.3523 14.5882 16.764 14.1765 16.117 14.1765C15.2346 14.1765 14.5287 14.8824 14.5287 15.7647C14.5287 16.6471 15.2346 17.353 16.117 17.353C16.764 17.353 17.3523 16.9412 17.5875 16.353H20.2934C19.4111 19.0588 16.8228 20.9412 13.8817 20.8824C8.4699 20.8235 7.4699 15.7647 7.41108 15.6471ZM16.4699 15.8235C16.4699 16.0588 16.2934 16.2353 16.0581 16.2353C15.8228 16.2353 15.6464 16.0588 15.6464 15.8235C15.6464 15.5882 15.8228 15.4118 16.0581 15.4118C16.2934 15.4118 16.4699 15.5882 16.4699 15.8235ZM13.9405 27.4706L9.70519 23.2353C10.117 22.8235 10.7052 22.2353 10.9993 21.5294C11.9405 21.9412 12.9405 22.1177 13.9405 22.1177C14.9405 22.1177 15.9405 21.9412 16.8817 21.5294C17.1758 22.2353 17.764 22.8235 18.1758 23.2353L13.9405 27.4706Z" fill="#2D3C58" />
                                    <path d="M25.4688 28.8235C25.4688 30.4118 26.7629 31.7059 28.3511 31.7059C29.9393 31.7059 31.2335 30.4118 31.2335 28.8235C31.2335 27.2353 29.9393 25.9412 28.3511 25.9412C26.7629 25.9412 25.4688 27.2353 25.4688 28.8235ZM30.057 28.8235C30.057 29.7647 29.2923 30.5294 28.3511 30.5294C27.4099 30.5294 26.6452 29.7647 26.6452 28.8235C26.6452 27.8823 27.4099 27.1176 28.3511 27.1176C29.2923 27.1176 30.057 27.8823 30.057 28.8235Z" fill="#2D3C58" />
                                </svg>
                            </div>
                            <h5 class="card-feature__single--title">
                                Stay online
                            </h5>
                            <p class="card-feature__single--description">
                                Experience no downtime when
                                you transfer your site.
                            </p>
                        </div>
                    </div>
                </div>
                <div class="col-xl-3 col-lg-4 col-md-6 col-sm-6">
                    <div class="card-feature">
                        <div class="card-feature__single">
                            <div class="card-feature__single--icon">
                                <svg width="33" height="40" viewBox="0 0 33 40" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path d="M16.3167 18.0416L7.38164 21.2982C7.15446 21.3785 7.00252 21.601 7.00004 21.8514V25.3864C6.99212 26.1828 8.13691 26.1828 8.12701 25.3864V22.2698L16.4994 19.2186L24.8777 22.2698V25.3864C24.844 26.2045 26.0349 26.2045 25.9992 25.3864V21.8514C25.9992 21.603 25.8492 21.3785 25.6221 21.2982L16.688 18.0416C16.533 17.9851 16.4682 17.9872 16.3167 18.0416Z" fill="#2D3C58" />
                                    <path fill-rule="evenodd" clip-rule="evenodd" d="M15.2434 1.34012C18.1558 0.590499 21.0658 2.51958 21.7632 5.64952C22.4577 8.77945 20.6713 11.912 17.7584 12.659C14.8441 13.406 11.934 11.4795 11.2386 8.34961C10.5417 5.21967 12.3291 2.08817 15.2434 1.34012ZM14.9885 0.191432C11.5069 1.08503 9.34418 4.86443 10.1793 8.62191C11.0135 12.3794 14.5306 14.7023 18.0132 13.8087C21.4958 12.9151 23.6557 9.13522 22.8205 5.37773C21.9854 1.62077 18.4682 -0.702686 14.9885 0.191432Z" fill="#2D3C58" />
                                    <path d="M10.7258 16.1399H22.2762C23.8121 16.1399 24.8046 16.4083 25.6193 17.0014C26.435 17.5951 27.1168 18.5751 27.8633 20.1145L31.3462 27.297C31.8296 28.2932 31.9402 29.0518 31.7821 29.585C31.624 30.1211 31.2013 30.5605 30.2619 30.9221L26.585 32.349C25.9804 32.5851 25.5274 32.523 25.1486 32.3203C24.7728 32.118 24.4728 31.7422 24.3152 31.2928C23.9995 30.3925 24.197 29.3176 25.4299 28.7895C26.5249 28.3194 28.4315 27.5472 28.4315 27.5472C29.2159 27.2976 28.7391 26.1233 28.0022 26.4885C28.0022 26.4885 26.0981 27.2607 24.9778 27.7414C23.2308 28.4904 22.7495 30.2951 23.2338 31.6716C23.297 31.8552 23.3808 32.0318 23.4758 32.1997C22.0131 34.992 19.5665 37.0671 16.4993 38.7381C13.4325 37.0671 10.988 34.992 9.52277 32.1997C9.62025 32.0318 9.70156 31.8552 9.76722 31.6716C10.2516 30.2951 9.77025 28.4904 8.02019 27.7414C6.90248 27.2607 4.99787 26.4885 4.99787 26.4885C4.25895 26.1233 3.78268 27.2976 4.56957 27.5472C4.56957 27.5472 6.47368 28.32 7.57018 28.7895C8.80153 29.3176 9.00154 30.3925 8.68587 31.2928C8.52779 31.7422 8.22525 32.118 7.84948 32.3203C7.47371 32.523 7.01814 32.5851 6.41307 32.349L2.7387 30.9226C1.79978 30.5605 1.37552 30.1211 1.21744 29.5855C1.05784 29.0518 1.16996 28.2932 1.65129 27.2976L5.13929 20.115C5.88426 18.5756 6.5656 17.5956 7.38078 17.0019C8.19747 16.4083 9.18892 16.1399 10.7258 16.1399ZM10.7258 15C9.05255 15 7.75857 15.3072 6.70601 16.0749C5.65345 16.8415 4.88776 18.0052 4.10693 19.6157L0.624488 26.7982C0.073964 27.9326 -0.159882 28.9757 0.11639 29.9113C0.395692 30.8464 1.18663 31.5501 2.32606 31.9919L6.00043 33.4183C6.87419 33.7573 7.72675 33.6862 8.39142 33.3286C8.50506 33.268 8.61264 33.1949 8.71517 33.1182C10.3804 36.0603 13.0239 38.2388 16.2311 39.933C16.3998 40.0223 16.6018 40.0223 16.768 39.933C19.9751 38.2388 22.6207 36.0603 24.2839 33.1182C24.3884 33.1949 24.494 33.2685 24.6096 33.3286C25.2728 33.6857 26.1279 33.7573 27.0006 33.4183L30.678 31.9919C31.8175 31.5501 32.6064 30.8459 32.8826 29.9113C33.1589 28.9762 32.9301 27.9326 32.3776 26.7982L28.8946 19.6157C28.1133 18.0057 27.3461 16.8415 26.2935 16.0749C25.244 15.3077 23.9495 15 22.2767 15H10.7258Z" fill="#2D3C58" />
                                    <path fill-rule="evenodd" clip-rule="evenodd" d="M20.8512 26.3508L14.894 32.6988C14.8544 32.7407 14.8067 32.7407 14.7671 32.6988L11.1739 28.9031L12.2892 27.6967L14.4279 29.9616C14.6528 30.1964 15.0178 30.1964 15.2427 29.9616L19.6628 25.2897L20.8512 26.3508ZM19.709 24.0082C19.344 24.0495 19.0506 24.22 18.8541 24.4269L14.8386 28.6688L13.1065 26.842C12.6334 26.3363 11.8324 26.3363 11.3587 26.842L10.3571 27.917C9.88096 28.4227 9.88096 29.2527 10.3571 29.7583L13.9584 33.5616C14.5076 34.1423 15.1559 34.1482 15.7037 33.5669L21.6685 27.2082C22.1604 26.6833 22.0594 25.8173 21.6624 25.3733L20.6771 24.3428C20.3958 24.0527 20.0263 23.9717 19.709 24.0082Z" fill="#2D3C58" />
                                </svg>
                            </div>
                            <h5 class="card-feature__single--title">
                                Free Privacy Protection
                            </h5>
                            <p class="card-feature__single--description">
                                Free WHOIS privacy protection
                                included with every eligible.
                            </p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- SERVICES END -->

    <!-- TRANSFER PRICE -->
    <div class="rts-transfer-price-table alice__blue section__padding">
        <div class="container">
            <div class="row">
                <div class="row justify-content-center">
                    <div class="rts-section w-450 text-center">
                        <h2 class="rts-section__title " data-sal="slide-down" data-sal-delay="100" data-sal-duration="800">
                            Check Our Domain
                            Transfer Prices
                        </h2>
                    </div>
                </div>
            </div>
            <!-- transfer rate table -->
            <div class="row justify-content-center">
                <div class="col-lg-10">
                    <div class="transfer-domain-table">
                        <table class="table table-responsive transfer-domain">
                            <thead class="heading__bg">
                                <tr>
                                    <th class="cell">Domains</th>
                                    <th class="cell text-center">Transfer / Renewal Price</th>
                                    <th class="cell text-center">Privacy Protection</th>
                                </tr>
                            </thead>
                            <tbody class="table__content">
                                <tr>
                                    <td class="tld">.com</td>
                                    <td class="price text-center">
                                        <h5 class="transfer">$8.99 /year</h5>
                                        <p class="renew">Renewal Price $15.99 /year</p>
                                    </td>
                                    <td class="protection text-center"><i class="fa-regular fa-check"></i></td>
                                </tr>
                                <tr>
                                    <td class="tld">.net</td>
                                    <td class="price text-center">
                                        <h5 class="transfer">$8.99 /year</h5>
                                        <p class="renew">Renewal Price $15.99 /year</p>
                                    </td>
                                    <td class="protection text-center"><i class="fa-regular fa-check"></i></td>
                                </tr>
                                <tr>
                                    <td class="tld">.xyz</td>
                                    <td class="price text-center">
                                        <h5 class="transfer">$8.99 /year</h5>
                                        <p class="renew">Renewal Price $15.99 /year</p>
                                    </td>
                                    <td class="protection text-center"><i class="fa-regular fa-xmark"></i></td>
                                </tr>
                                <tr>
                                    <td class="tld">.online</td>
                                    <td class="price text-center">
                                        <h5 class="transfer">$8.99 /year</h5>
                                        <p class="renew">Renewal Price $15.99 /year</p>
                                    </td>
                                    <td class="protection text-center"><i class="fa-regular fa-check"></i></td>
                                </tr>
                                <tr>
                                    <td class="tld">.pw</td>
                                    <td class="price text-center">
                                        <h5 class="transfer">$8.99 /year</h5>
                                        <p class="renew">Renewal Price $15.99 /year</p>
                                    </td>
                                    <td class="protection text-center"><i class="fa-regular fa-check"></i></td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- TRANSFER PRICE END -->

    <!-- why transfer with us -->
    <div class="rts-why-transfer section__padding">
        <div class="container">
            <div class="row justify-content-center">
                <div class="rts-section w-670 text-center">
                    <h2 class="rts-section__title" data-sal="slide-down" data-sal-delay="100" data-sal-duration="800">
                        How to transfer your domain
                    </h2>
                    <p class="rts-section__description" data-sal="slide-down" data-sal-delay="300" data-sal-duration="800">
                        Better service, support, and savings in 3 easy steps
                    </p>
                </div>
            </div>
            <!-- content -->
            <div class="row justify-content-sm-center justify-content-md-start g-30">
                <div class="col-lg-4 col-md-6 col-sm-10">
                    <div class="card-feature ">
                        <div class="card-feature__single">
                            <div class="card-feature__single--icon">
                                <svg width="40" height="40" viewBox="0 0 40 40" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path d="M34.1172 4.65781H30.5008V2.35C30.5008 1.05469 29.4469 0 28.1508 0C26.8547 0 25.8008 1.05391 25.8008 2.35V4.65781H14.2016V2.35C14.2016 1.05469 13.1484 0 11.8539 0C10.5586 0 9.50391 1.05391 9.50391 2.35V4.65781H5.88594C3.26328 4.65781 1.12891 6.79141 1.12891 9.41484V35.243C1.12891 37.8656 3.2625 40 5.88594 40H34.1172C36.7398 40 38.8742 37.8664 38.8742 35.243V9.41406C38.8742 6.79141 36.7398 4.65781 34.1172 4.65781ZM27.0508 2.35C27.0508 1.74297 27.5445 1.24922 28.1516 1.24922C28.7586 1.24922 29.2523 1.74297 29.2523 2.35V8.21406C29.2523 8.82109 28.7586 9.31484 28.1516 9.31484C27.5445 9.31484 27.0508 8.82109 27.0508 8.21406V2.35ZM10.7539 2.35C10.7539 1.74297 11.2477 1.24922 11.8547 1.24922C12.4602 1.24922 12.9531 1.74297 12.9531 2.35V8.21406C12.9531 8.82109 12.4602 9.31484 11.8547 9.31484C11.2477 9.31484 10.7539 8.82109 10.7539 8.21406V2.35ZM5.88594 5.90625H9.50469V8.21406C9.50469 9.50937 10.5586 10.5641 11.8547 10.5641C13.1492 10.5641 14.2023 9.51016 14.2023 8.21406V5.90625H25.8023V8.21406C25.8023 9.50937 26.8563 10.5641 28.1523 10.5641C29.4484 10.5641 30.5023 9.51016 30.5023 8.21406V5.90625H34.1188C36.0531 5.90625 37.6266 7.47969 37.6266 9.41406V13.4531H2.37813V9.41406C2.37813 7.48047 3.95156 5.90625 5.88594 5.90625ZM34.1172 38.7508H5.88594C3.95156 38.7508 2.37813 37.1773 2.37813 35.243V14.7031H37.625V35.243C37.625 37.1773 36.0516 38.7508 34.1172 38.7508ZM9.50703 19.482H7.60625C6.60156 19.482 5.78359 20.3 5.78359 21.3047V23.2047C5.78359 24.2094 6.60156 25.0273 7.60625 25.0273H9.50625C10.5109 25.0273 11.3289 24.2094 11.3289 23.2047V21.3047C11.3297 20.2992 10.5117 19.482 9.50703 19.482ZM10.0805 23.2047C10.0805 23.5211 9.82344 23.7781 9.50703 23.7781H7.60625C7.29531 23.7781 7.03281 23.5156 7.03281 23.2047V21.3047C7.03281 20.9883 7.28984 20.7312 7.60625 20.7312H9.50625C9.82266 20.7312 10.0797 20.9883 10.0797 21.3047V23.2047H10.0805ZM20.9516 19.482H19.0539C18.0477 19.482 17.2289 20.3 17.2289 21.3047V23.2047C17.2289 24.2094 18.0477 25.0273 19.0539 25.0273H20.9516C21.9563 25.0273 22.7742 24.2094 22.7742 23.2047V21.3047C22.7742 20.2992 21.9563 19.482 20.9516 19.482ZM21.525 23.2047C21.525 23.5211 21.268 23.7781 20.9516 23.7781H19.0539C18.7414 23.7781 18.4781 23.5156 18.4781 23.2047V21.3047C18.4781 20.9883 18.7367 20.7312 19.0539 20.7312H20.9516C21.268 20.7312 21.525 20.9883 21.525 21.3047V23.2047ZM32.3969 19.482H30.4992C29.493 19.482 28.6742 20.3 28.6742 21.3047V23.2047C28.6742 24.2094 29.493 25.0273 30.4992 25.0273H32.3969C33.4031 25.0273 34.2219 24.2094 34.2219 23.2047V21.3047C34.2211 20.2992 33.4023 19.482 32.3969 19.482ZM32.9727 23.2047C32.9727 23.5156 32.7086 23.7781 32.3969 23.7781H30.4992C30.1867 23.7781 29.9234 23.5156 29.9234 23.2047V21.3047C29.9234 20.9883 30.182 20.7312 30.4992 20.7312H32.3969C32.7141 20.7312 32.9727 20.9883 32.9727 21.3047V23.2047ZM9.50703 28.4266H7.60625C6.60156 28.4266 5.78359 29.2453 5.78359 30.2516V32.1492C5.78359 33.1539 6.60156 33.9719 7.60625 33.9719H9.50625C10.5109 33.9719 11.3289 33.1539 11.3289 32.1492V30.2516C11.3297 29.2453 10.5117 28.4266 9.50703 28.4266ZM10.0805 32.1492C10.0805 32.4656 9.82344 32.7227 9.50703 32.7227H7.60625C7.28984 32.7227 7.03281 32.4656 7.03281 32.1492V30.2516C7.03281 29.9391 7.29531 29.6758 7.60625 29.6758H9.50625C9.82266 29.6758 10.0797 29.9344 10.0797 30.2516V32.1492H10.0805ZM20.9516 28.4266H19.0539C18.0477 28.4266 17.2289 29.2453 17.2289 30.2516V32.1492C17.2289 33.1539 18.0477 33.9719 19.0539 33.9719H20.9516C21.9563 33.9719 22.7742 33.1539 22.7742 32.1492V30.2516C22.7742 29.2453 21.9563 28.4266 20.9516 28.4266ZM21.525 32.1492C21.525 32.4656 21.268 32.7227 20.9516 32.7227H19.0539C18.7367 32.7227 18.4781 32.4656 18.4781 32.1492V30.2516C18.4781 29.9344 18.7367 29.6758 19.0539 29.6758H20.9516C21.268 29.6758 21.525 29.9344 21.525 30.2516V32.1492ZM32.3969 28.4266H30.4992C29.493 28.4266 28.6742 29.2453 28.6742 30.2516V32.1492C28.6742 33.1539 29.493 33.9719 30.4992 33.9719H32.3969C33.4031 33.9719 34.2219 33.1539 34.2219 32.1492V30.2516C34.2211 29.2453 33.4023 28.4266 32.3969 28.4266ZM32.9727 32.1492C32.9727 32.4656 32.7141 32.7227 32.3969 32.7227H30.4992C30.182 32.7227 29.9234 32.4656 29.9234 32.1492V30.2516C29.9234 29.9344 30.182 29.6758 30.4992 29.6758H32.3969C32.7141 29.6758 32.9727 29.9344 32.9727 30.2516V32.1492Z" fill="white" />
                                </svg>
                            </div>
                            <h5 class="card-feature__single--title">
                                Complete your check
                            </h5>
                            <p class="card-feature__single--description">
                                Enter your domain name into the search
                                bar and make sure it meets our transfer
                                requirements.
                            </p>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4 col-md-6 col-sm-10">
                    <div class="card-feature ">
                        <div class="card-feature__single">
                            <div class="card-feature__single--icon">
                                <svg width="40" height="40" viewBox="0 0 40 40" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <g clip-path="url(#clip0_852_1427)">
                                        <path d="M23.908 25.2068C24.4031 25.2068 24.8661 25.0117 25.2118 24.6573L28.283 21.5085C28.9839 20.7898 28.9694 19.6348 28.2506 18.9338C27.5317 18.2329 26.3765 18.2474 25.6756 18.9661L23.8739 20.8132L23.5583 20.5063C22.8385 19.8066 21.6833 19.8226 20.9832 20.5424C20.2834 21.2621 20.2996 22.4171 21.0194 23.1171L22.6386 24.6914C22.9804 25.0238 23.4313 25.2068 23.908 25.2068ZM21.8253 21.361C22.074 21.1052 22.4844 21.0999 22.7398 21.3482L23.4757 22.0638C23.7078 22.2896 24.0791 22.2846 24.3053 22.0528L26.5163 19.786C26.7653 19.5307 27.1756 19.5257 27.4307 19.7745C27.686 20.0235 27.6911 20.4336 27.4423 20.6889L24.3711 23.8375C24.1338 24.0914 23.7014 24.0967 23.4573 23.8497L21.8381 22.2753C21.5825 22.0267 21.5767 21.6165 21.8253 21.361Z" fill="#2D3C58" />
                                        <path d="M19.3675 25.6064C19.1722 25.3475 18.8041 25.296 18.5451 25.4913C18.2862 25.6866 18.2348 26.0547 18.43 26.3136C18.6438 26.5969 18.8804 26.8686 19.1329 27.1211C20.5766 28.5646 22.496 29.3596 24.5377 29.3596C26.5793 29.3596 28.4987 28.5646 29.9423 27.1211C31.3861 25.6777 32.1811 23.7585 32.1811 21.7171C32.1811 19.6757 31.386 17.7566 29.9423 16.3132C26.9621 13.3334 22.1131 13.3335 19.1329 16.3132C17.1011 18.3446 16.3821 21.3082 17.2566 24.0472C17.3552 24.3561 17.6858 24.5264 17.9944 24.428C18.3034 24.3294 18.4739 23.999 18.3752 23.6902C17.635 21.3716 18.2435 18.863 19.9634 17.1435C22.4855 14.6215 26.5898 14.6215 29.1119 17.1435C30.3338 18.3652 31.0068 19.9895 31.0068 21.7172C31.0068 23.445 30.3338 25.0693 29.1119 26.291C27.8902 27.5126 26.2656 28.1855 24.5377 28.1855C22.8098 28.1855 21.1852 27.5127 19.9633 26.291C19.7491 26.0766 19.5486 25.8464 19.3675 25.6064Z" fill="#2D3C58" />
                                        <path d="M39.1923 32.443L35.488 28.7392C35.2586 28.51 34.8869 28.5099 34.6575 28.7392L34.6348 28.7619L33.2093 27.3366C34.1676 25.8592 34.7385 24.1523 34.8509 22.3708C34.8713 22.0472 34.6254 21.7684 34.3018 21.7479C33.9784 21.7282 33.6994 21.9734 33.6788 22.2969C33.5386 24.521 32.5924 26.6148 31.0146 28.1923C29.2315 29.9753 26.8898 30.8678 24.5475 30.8701C24.5445 30.87 24.5416 30.8696 24.5386 30.8696H24.492C22.1623 30.8579 19.8362 29.9657 18.0626 28.1923C16.3327 26.4628 15.3801 24.1632 15.3801 21.7172C15.3801 19.2712 16.3327 16.9716 18.0626 15.242C21.6334 11.6716 27.4438 11.6716 31.0146 15.242C32.3446 16.5719 33.2223 18.2493 33.5528 20.0931C33.6101 20.4123 33.9154 20.6243 34.2344 20.5674C34.5536 20.5102 34.7659 20.2052 34.7088 19.8859C34.3356 17.8049 33.3454 15.912 31.845 14.4117C31.1016 13.6684 30.2719 13.0627 29.388 12.5937V7.86195C29.3876 7.70742 29.3252 7.55617 29.2161 7.4468L21.9403 0.171953C21.8309 0.0630469 21.6797 0.000390625 21.525 0H1.76156C0.790313 0 7.8125e-05 0.790078 7.8125e-05 1.76125V6.69586C7.8125e-05 7.02008 0.262891 7.28297 0.587266 7.28297C0.911563 7.28297 1.17445 7.02016 1.17445 6.69586V1.76125C1.17445 1.4375 1.43781 1.17414 1.76164 1.17414H20.938V6.68781C20.938 7.65898 21.7283 8.44906 22.6995 8.44906H28.2139V12.062C27.0683 11.6279 25.8605 11.4049 24.6507 11.3919C24.6449 11.3911 24.6393 11.3899 24.6333 11.3899H11.5239C11.1996 11.3899 10.9367 11.6528 10.9367 11.977C10.9367 12.3013 11.1996 12.5641 11.5239 12.5641H19.7447C18.9071 13.0021 18.1176 13.5627 17.4026 14.2458H11.5239C11.1996 14.2458 10.9367 14.5087 10.9367 14.8329C10.9367 15.1571 11.1996 15.42 11.5239 15.42H16.3458C15.3873 16.6615 14.7323 18.0913 14.4188 19.6177H11.524C11.1997 19.6177 10.9368 19.8805 10.9368 20.2048C10.9368 20.529 11.1997 20.7919 11.524 20.7919H14.2473C14.2203 21.0979 14.206 21.4065 14.206 21.7173C14.206 21.9723 14.2153 22.2259 14.2335 22.4777H11.5241C11.1998 22.4777 10.9369 22.7406 10.9369 23.0648C10.9369 23.3891 11.1998 23.652 11.5241 23.652H14.3866C14.686 25.2411 15.3537 26.7302 16.3476 28.0168H11.5241C11.1998 28.0168 10.9369 28.2796 10.9369 28.6039C10.9369 28.9282 11.1998 29.191 11.5241 29.191H17.4049C18.1189 29.8728 18.9072 30.4325 19.7433 30.8699H11.5238C11.1995 30.8699 10.9366 31.1328 10.9366 31.457C10.9366 31.7812 11.1995 32.0441 11.5238 32.0441H24.5386C25.7856 32.044 27.0327 31.82 28.2138 31.3726V38.2391C28.2138 38.5627 27.9504 38.8262 27.6266 38.8262H1.76156C1.43781 38.8262 1.17438 38.5628 1.17438 38.2391V9.04453C1.17438 8.72031 0.911484 8.45742 0.587187 8.45742C0.262891 8.45742 0 8.72023 0 9.04453V38.2391C7.8125e-05 39.2099 0.790313 40 1.76156 40H27.6266C28.5979 40 29.3881 39.2099 29.3881 38.2388V30.8405C29.6502 30.7015 29.9073 30.5502 30.159 30.3871L31.5842 31.8121C31.3376 32.0274 31.3244 32.4377 31.5615 32.6651L35.2659 36.369C36.2992 37.4459 38.1589 37.4459 39.1922 36.369C40.2694 35.3357 40.2693 33.4762 39.1923 32.443ZM22.6995 7.27492C22.3757 7.27492 22.1123 7.01156 22.1123 6.68781V2.00445L27.3834 7.27492H22.6995ZM31.1168 29.6842C31.3673 29.4771 31.6106 29.257 31.845 29.0227C32.078 28.7897 32.2984 28.5465 32.5066 28.2945L33.8044 29.5921L32.4145 30.9817L31.1168 29.6842ZM38.3619 35.5387C37.7656 36.1602 36.6926 36.16 36.0963 35.5387L32.807 32.2499L35.0727 29.9845L38.362 33.2733C38.9834 33.8696 38.9834 34.9424 38.3619 35.5387Z" fill="#2D3C58" />
                                        <path d="M5.32898 16.0002H7.89773C8.62195 16.0002 9.21117 15.4111 9.21117 14.6871V12.1186C9.21117 11.3945 8.62203 10.8054 7.89773 10.8054H5.32898C4.60484 10.8054 4.01562 11.3945 4.01562 12.1186V14.6871C4.01562 15.4111 4.60484 16.0002 5.32898 16.0002ZM5.19 12.1186C5.19 12.042 5.25242 11.9796 5.32898 11.9796H7.89773C7.97445 11.9796 8.0368 12.042 8.0368 12.1186V14.6871C8.0368 14.7637 7.97437 14.826 7.89773 14.826H5.32898C5.25234 14.826 5.19 14.7637 5.19 14.6871V12.1186Z" fill="#2D3C58" />
                                        <path d="M4.01562 22.9189C4.01562 23.643 4.60477 24.232 5.32898 24.232H7.89773C8.62195 24.232 9.21117 23.643 9.21117 22.9189V20.3505C9.21117 19.6264 8.62203 19.0374 7.89773 19.0374H5.32898C4.60484 19.0374 4.01562 19.6264 4.01562 20.3505V22.9189ZM5.19 20.3505C5.19 20.2738 5.25242 20.2115 5.32898 20.2115H7.89773C7.97445 20.2115 8.0368 20.2738 8.0368 20.3505V22.9189C8.0368 22.9956 7.97437 23.0579 7.89773 23.0579H5.32898C5.25234 23.0579 5.19 22.9956 5.19 22.9189V20.3505Z" fill="#2D3C58" />
                                        <path d="M4.01562 31.3179C4.01562 32.042 4.60477 32.631 5.32898 32.631H7.89773C8.62195 32.631 9.21117 32.042 9.21117 31.3179V28.7495C9.21117 28.0253 8.62203 27.4363 7.89773 27.4363H5.32898C4.60484 27.4363 4.01562 28.0253 4.01562 28.7495V31.3179ZM5.19 28.7495C5.19 28.6728 5.25242 28.6105 5.32898 28.6105H7.89773C7.97445 28.6105 8.0368 28.6728 8.0368 28.7495V31.3179C8.0368 31.3946 7.97437 31.4569 7.89773 31.4569H5.32898C5.25234 31.4569 5.19 31.3946 5.19 31.3179V28.7495Z" fill="#2D3C58" />
                                    </g>
                                    <defs>
                                        <clipPath id="clip0_852_1427">
                                            <rect width="40" height="40" fill="white" />
                                        </clipPath>
                                    </defs>
                                </svg>
                            </div>
                            <h5 class="card-feature__single--title">
                                Prepare it for transfer
                            </h5>
                            <p class="card-feature__single--description">
                                Look at your domain type requirements and get your authorization code ready.
                                domain prepare if transfer.
                            </p>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4 col-md-6 col-sm-10">
                    <div class="card-feature ">
                        <div class="card-feature__single">
                            <div class="card-feature__single--icon">
                                <svg width="40" height="40" viewBox="0 0 40 40" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <g clip-path="url(#clip0_863_1384)">
                                        <path d="M21.4492 7.26496C21.1276 7.22878 20.8376 7.46011 20.8014 7.78159C20.7653 8.10315 20.9966 8.39323 21.3181 8.4294C27.205 9.09236 31.6441 14.0666 31.6441 20C31.6441 26.4207 26.4205 31.6443 19.9998 31.6443C13.5791 31.6443 8.35546 26.4207 8.35546 20C8.35546 14.0743 12.7882 9.1008 18.6664 8.43112C18.9879 8.39448 19.2189 8.10417 19.1823 7.78261C19.1457 7.46105 18.8557 7.22972 18.5338 7.26675C12.0632 8.00401 7.18359 13.478 7.18359 20C7.18359 27.0669 12.9329 32.8162 19.9998 32.8162C27.0667 32.8162 32.816 27.0669 32.816 20C32.816 13.4696 27.9293 7.99471 21.4492 7.26496Z" fill="#2D3C58" />
                                        <path d="M34.4063 25.2258C34.1228 24.3198 34.391 23.3189 35.0895 22.6759C35.8356 21.9893 36.2636 21.0139 36.2636 20C36.2636 18.986 35.8356 18.0106 35.0896 17.324C34.391 16.6811 34.1228 15.6802 34.4063 14.7741C34.7092 13.8063 34.592 12.7477 34.0851 11.8696C33.5781 10.9915 32.7198 10.3607 31.7304 10.1391C30.804 9.93162 30.0712 9.19889 29.8637 8.2725C29.6422 7.28305 29.0114 6.42478 28.1333 5.91775C27.2552 5.41073 26.1965 5.29362 25.2288 5.59651C24.3227 5.88002 23.3218 5.61182 22.6789 4.91331C21.9922 4.16722 21.0169 3.73926 20.0029 3.73926C18.9889 3.73926 18.0135 4.16722 17.3269 4.91323C16.684 5.61182 15.6832 5.88002 14.777 5.59651C13.8093 5.2937 12.7506 5.41073 11.8725 5.91775C10.9944 6.4247 10.3636 7.28305 10.142 8.2725C9.93455 9.19889 9.20182 9.93162 8.27542 10.1391C7.28598 10.3607 6.42771 10.9915 5.92068 11.8696C5.41366 12.7477 5.29663 13.8063 5.59944 14.7741C5.88295 15.6802 5.61475 16.681 4.91624 17.324C4.17015 18.0106 3.74219 18.986 3.74219 20C3.74219 21.0139 4.17015 21.9893 4.91616 22.6759C5.61475 23.3188 5.88295 24.3198 5.59944 25.2258C5.29663 26.1936 5.41373 27.2522 5.92068 28.1303C6.42763 29.0085 7.28598 29.6392 8.27542 29.8608C9.20182 30.0683 9.93455 30.801 10.142 31.7274C10.3636 32.7169 10.9944 33.5751 11.8725 34.0822C12.7507 34.5891 13.8093 34.7063 14.777 34.4034C15.6833 34.12 16.684 34.3881 17.3269 35.0866C18.0135 35.8327 18.9889 36.2607 20.0029 36.2607C21.0169 36.2607 21.9922 35.8327 22.6789 35.0867C23.3218 34.3881 24.3228 34.1199 25.2288 34.4034C26.1963 34.7061 27.2552 34.5891 28.1333 34.0822C29.0114 33.5752 29.6422 32.7169 29.8637 31.7274C30.0712 30.801 30.804 30.0683 31.7304 29.8608C32.7198 29.6392 33.5781 29.0085 34.0851 28.1303C34.5921 27.2522 34.7092 26.1936 34.4063 25.2258ZM33.288 25.5758C33.4963 26.2414 33.4189 26.9405 33.0703 27.5444C32.7216 28.1483 32.1548 28.5649 31.4743 28.7173C30.1074 29.0235 29.0264 30.1045 28.7202 31.4713C28.5678 32.1518 28.1513 32.7186 27.5473 33.0673C26.9434 33.416 26.2442 33.4933 25.5788 33.2851C24.2418 32.8666 22.7652 33.2624 21.8167 34.2931C21.3444 34.8062 20.7003 35.0889 20.003 35.0889C19.3056 35.0889 18.6615 34.8063 18.1892 34.2931C17.4917 33.5352 16.5085 33.1207 15.5055 33.1207C15.1445 33.1207 14.7809 33.1744 14.4272 33.2851C13.7617 33.4932 13.0625 33.4159 12.4586 33.0673C11.8547 32.7187 11.4381 32.1519 11.2857 31.4713C10.9795 30.1045 9.89853 29.0235 8.53167 28.7173C7.85121 28.5649 7.28442 28.1484 6.93567 27.5444C6.587 26.9405 6.50966 26.2414 6.71794 25.5758C7.13622 24.2391 6.7406 22.7624 5.7099 21.8138C5.19678 21.3415 4.91413 20.6974 4.91413 20C4.91413 19.3027 5.1967 18.6586 5.7099 18.1863C6.74052 17.2377 7.13622 15.761 6.71794 14.4242C6.50966 13.7587 6.587 13.0596 6.93567 12.4557C7.28434 11.8518 7.85113 11.4352 8.53167 11.2828C9.89853 10.9766 10.9795 9.8956 11.2857 8.52874C11.4381 7.84828 11.8546 7.28149 12.4586 6.93274C13.0626 6.584 13.7618 6.50673 14.4272 6.71501C15.7639 7.13329 17.2407 6.73759 18.1892 5.70697C18.6615 5.19385 19.3056 4.9112 20.003 4.9112C20.7003 4.9112 21.3444 5.19378 21.8167 5.70697C22.7654 6.73759 24.242 7.13329 25.5788 6.71501C26.2442 6.50673 26.9434 6.584 27.5473 6.93274C28.1512 7.28141 28.5678 7.8482 28.7202 8.52874C29.0264 9.8956 30.1074 10.9766 31.4743 11.2828C32.1547 11.4352 32.7215 11.8517 33.0703 12.4557C33.4189 13.0596 33.4963 13.7587 33.288 14.4242C32.8697 15.761 33.2653 17.2377 34.296 18.1863C34.8092 18.6586 35.0918 19.3027 35.0918 20C35.0918 20.6974 34.8092 21.3415 34.296 21.8138C33.2653 22.7624 32.8696 24.2391 33.288 25.5758Z" fill="#2D3C58" />
                                        <path d="M34.3515 6.07304C34.5015 6.07304 34.6515 6.01585 34.7658 5.9014L39.6668 1.00046C39.8956 0.771631 39.8956 0.400615 39.6668 0.171865C39.4379 -0.0569629 39.0669 -0.0569629 38.8382 0.171865L33.9372 5.0728C33.7084 5.30163 33.7084 5.67265 33.9372 5.9014C34.0516 6.01577 34.2015 6.07304 34.3515 6.07304Z" fill="#2D3C58" />
                                        <path d="M39.8166 8.20333C39.7315 7.89114 39.4095 7.70708 39.0972 7.79231L36.6467 8.46083C36.3345 8.54599 36.1504 8.8681 36.2357 9.18028C36.3068 9.44083 36.5429 9.61216 36.8006 9.61216C36.8516 9.61216 36.9036 9.60544 36.9552 9.5913L39.4057 8.92278C39.7178 8.83771 39.9018 8.51552 39.8166 8.20333Z" fill="#2D3C58" />
                                        <path d="M30.6076 3.60182C30.6592 3.61596 30.7111 3.62268 30.7622 3.62268C31.0199 3.62268 31.256 3.45135 31.3271 3.19081L31.9956 0.740338C32.0808 0.42815 31.8968 0.105963 31.5846 0.0208845C31.2724 -0.0645061 30.9503 0.119713 30.8652 0.4319L30.1966 2.88237C30.1113 3.19456 30.2953 3.51667 30.6076 3.60182Z" fill="#2D3C58" />
                                        <path d="M5.23662 5.90164C5.351 6.01602 5.501 6.07328 5.65092 6.07328C5.80084 6.07328 5.95084 6.01609 6.06522 5.90164C6.29404 5.67281 6.29404 5.3018 6.06522 5.07305L1.16428 0.172109C0.935449 -0.0567187 0.564434 -0.0567187 0.335684 0.172109C0.106855 0.400937 0.106855 0.771953 0.335684 1.0007L5.23662 5.90164Z" fill="#2D3C58" />
                                        <path d="M3.35479 8.46086L0.904319 7.79234C0.592132 7.70703 0.269944 7.89117 0.184866 8.20336C0.0997097 8.51555 0.283694 8.83773 0.595882 8.92281L3.04635 9.59133C3.09799 9.60547 3.14987 9.61219 3.20096 9.61219C3.45862 9.61219 3.69479 9.44086 3.76588 9.18031C3.85096 8.86812 3.66697 8.54601 3.35479 8.46086Z" fill="#2D3C58" />
                                        <path d="M8.67755 3.19077C8.74864 3.45132 8.98481 3.62265 9.24247 3.62265C9.29349 3.62265 9.34544 3.61593 9.39708 3.60179C9.70927 3.51663 9.89333 3.19452 9.8081 2.88234L9.13958 0.431868C9.05442 0.119758 8.73263 -0.0644604 8.42013 0.0208521C8.10794 0.106008 7.92388 0.428118 8.00911 0.740305L8.67755 3.19077Z" fill="#2D3C58" />
                                        <path d="M34.7658 34.0986C34.537 33.8698 34.166 33.8698 33.9372 34.0986C33.7084 34.3275 33.7084 34.6985 33.9372 34.9272L38.8382 39.8282C38.9526 39.9425 39.1026 39.9998 39.2525 39.9998C39.4024 39.9998 39.5524 39.9426 39.6668 39.8282C39.8956 39.5993 39.8956 39.2283 39.6668 38.9996L34.7658 34.0986Z" fill="#2D3C58" />
                                        <path d="M39.4056 31.077L36.9551 30.4085C36.6428 30.3233 36.3208 30.5074 36.2356 30.8195C36.1505 31.1317 36.3345 31.4539 36.6467 31.539L39.0971 32.2075C39.1488 32.2217 39.2006 32.2284 39.2517 32.2284C39.5094 32.2284 39.7456 32.057 39.8167 31.7965C39.9018 31.4843 39.7178 31.1622 39.4056 31.077Z" fill="#2D3C58" />
                                        <path d="M31.3271 36.8091C31.2419 36.497 30.9198 36.3127 30.6076 36.398C30.2954 36.4832 30.1114 36.8053 30.1966 37.1175L30.8651 39.568C30.9362 39.8285 31.1724 39.9998 31.43 39.9998C31.4811 39.9998 31.5329 39.9931 31.5847 39.979C31.8968 39.8938 32.0809 39.5717 31.9957 39.2595L31.3271 36.8091Z" fill="#2D3C58" />
                                        <path d="M5.23662 34.0986L0.335684 38.9996C0.106855 39.2284 0.106855 39.5994 0.335684 39.8282C0.450059 39.9425 0.600059 39.9998 0.74998 39.9998C0.899902 39.9998 1.0499 39.9426 1.16428 39.8282L6.06522 34.9272C6.29404 34.6984 6.29404 34.3274 6.06522 34.0986C5.83639 33.8698 5.46537 33.8698 5.23662 34.0986Z" fill="#2D3C58" />
                                        <path d="M3.04638 30.4086L0.595909 31.0771C0.283721 31.1623 0.0996586 31.4844 0.184893 31.7966C0.255987 32.0571 0.492159 32.2284 0.749815 32.2284C0.800831 32.2284 0.852784 32.2217 0.904424 32.2076L3.35489 31.539C3.66708 31.4539 3.85114 31.1318 3.76591 30.8196C3.68083 30.5074 3.35872 30.3232 3.04638 30.4086Z" fill="#2D3C58" />
                                        <path d="M9.39705 36.398C9.08487 36.3128 8.76276 36.4969 8.6776 36.809L8.00908 39.2595C7.92393 39.5717 8.10791 39.8939 8.4201 39.979C8.47174 39.9931 8.52362 39.9998 8.57471 39.9998C8.83237 39.9998 9.06854 39.8285 9.13963 39.568L9.80815 37.1175C9.8933 36.8054 9.70924 36.4832 9.39705 36.398Z" fill="#2D3C58" />
                                        <path d="M22.5258 21.896C22.297 22.1248 22.297 22.4959 22.5258 22.7246C22.7547 22.9534 23.1257 22.9534 23.3544 22.7246L28.1623 17.9168C28.5051 17.5739 28.694 17.1181 28.694 16.6332C28.694 16.1483 28.5051 15.6925 28.1623 15.3497L26.6513 13.8386C25.9435 13.1309 24.7919 13.1309 24.0842 13.8386L18.1269 19.7959L16.0427 17.7116C15.6998 17.3687 15.244 17.1799 14.7591 17.1799C14.2742 17.1799 13.8184 17.3687 13.4755 17.7116L11.8442 19.3429C11.5013 19.6858 11.3125 20.1416 11.3125 20.6265C11.3125 21.1114 11.5013 21.5672 11.8442 21.91L16.0238 26.0896C16.5704 26.6363 17.2885 26.9096 18.0065 26.9096C18.7245 26.9096 19.4426 26.6363 19.9892 26.0896L21.43 24.6489C21.6588 24.4201 21.6588 24.049 21.43 23.8203C21.2012 23.5915 20.8301 23.5915 20.6014 23.8203L19.1606 25.2611C18.5242 25.8974 17.4887 25.8974 16.8524 25.2611L12.6728 21.0814C12.5512 20.9599 12.4844 20.7984 12.4844 20.6266C12.4844 20.4547 12.5513 20.2931 12.6728 20.1717L14.3041 18.5403C14.4257 18.4189 14.5872 18.3519 14.759 18.3519C14.9308 18.3519 15.0924 18.4188 15.2139 18.5403L17.7125 21.0389C17.9413 21.2677 18.3124 21.2677 18.5411 21.0389L24.9128 14.6673C25.1635 14.4166 25.5717 14.4165 25.8226 14.6673L27.3336 16.1784C27.4552 16.2999 27.522 16.4615 27.522 16.6333C27.522 16.8051 27.4551 16.9667 27.3336 17.0882L22.5258 21.896Z" fill="#2D3C58" />
                                    </g>
                                    <defs>
                                        <clipPath id="clip0_863_1384">
                                            <rect width="40" height="40" fill="white" />
                                        </clipPath>
                                    </defs>
                                </svg>
                            </div>
                            <h5 class="card-feature__single--title">
                                Complete your check
                            </h5>
                            <p class="card-feature__single--description">
                                Add it to the cart and make your payment. Your transfer will complete within 30 minutes to 6 days.
                            </p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- why transfer with us end -->

    <!-- SUPPORT AREA -->
    <div class="rts-support black__friday--support">
        <div class="container">
            <div class="row">
                <div class="rts-support__wrapper">
                    <div class="rts-support__wrapper--content">
                        <h3 class="title" data-sal="slide-down" data-sal-delay="100" data-sal-duration="800">24/7 World-Class Support</h3>
                        <p data-sal="slide-down" data-sal-delay="200" data-sal-duration="800">Ran into trouble? Contact our Customer Success team any
                            time via live chat or email.
                        </p>
                        <div class="feature" data-sal="slide-down" data-sal-delay="300" data-sal-duration="800">
                            <ul class="feature__list">
                                <li class="feature__item">Receive professional WordPress support</li>
                                <li class="feature__item">Our specialists are available round</li>
                            </ul>
                        </div>
                        <a href="support.php" class="rts-btn rts-btn-primary support-btn">Get Support <i class="fa-regular fa-chevron-right"></i></a>
                    </div>
                    <div class="rts-support__wrapper--image" data-sal="slide-left" data-sal-delay="400" data-sal-duration="800">
                        <img src="assets/images/support/support__image.svg" alt="">
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- SUPPORT AREA END -->

    <!-- SHARED HOSTING FAQ -->
    <div class="rts-hosting-faq section__padding">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-lg-8">
                    <div class="rts-section text-center">
                        <h2 class="rts-section__title mb-0" data-sal="slide-down" data-sal-delay="100" data-sal-duration="800">Frequently asked questions</h2>
                    </div>
                    <div class="rts-faq__accordion" data-sal="slide-down" data-sal-delay="100" data-sal-duration="800">
                        <div class="accordion accordion-flush" id="rts-accordion">
                            <div class="accordion-item active">
                                <div class="accordion-header" id="first">
                                    <h4 class="accordion-button collapse show" data-bs-toggle="collapse" data-bs-target="#item__one" aria-expanded="false" aria-controls="item__one">
                                        How do I transfer a domain from one host to another?
                                    </h4>
                                </div>
                                <div id="item__one" class="accordion-collapse collapse collapse show" aria-labelledby="first" data-bs-parent="#rts-accordion">
                                    <div class="accordion-body">
                                        Above all else, we strive to deliver outstanding customer experiences. When you buy a domain name from hostie, we guarantee it will be handed over.
                                    </div>
                                </div>
                            </div>
                            <div class="accordion-item">
                                <div class="accordion-header" id="two">
                                    <h4 class="accordion-button collapsed" data-bs-toggle="collapse" data-bs-target="#item__two" aria-expanded="false" aria-controls="item__two">
                                        How does domain registration work?
                                    </h4>
                                </div>
                                <div id="item__two" class="accordion-collapse collapse" aria-labelledby="two" data-bs-parent="#rts-accordion">
                                    <div class="accordion-body">
                                        Above all else, we strive to deliver outstanding customer experiences. When you buy a domain name from hostie, we guarantee it will be handed over.
                                    </div>
                                </div>
                            </div>
                            <div class="accordion-item">
                                <div class="accordion-header" id="three">
                                    <h4 class="accordion-button collapsed" data-bs-toggle="collapse" data-bs-target="#item__three" aria-expanded="false" aria-controls="item__three">
                                        Why is domain name registration required?
                                    </h4>
                                </div>
                                <div id="item__three" class="accordion-collapse collapse" aria-labelledby="three" data-bs-parent="#rts-accordion">
                                    <div class="accordion-body">
                                        Above all else, we strive to deliver outstanding customer experiences. When you buy a domain name from hostie, we guarantee it will be handed over.
                                    </div>
                                </div>
                            </div>

                            <div class="accordion-item">
                                <div class="accordion-header" id="four">
                                    <h4 class="accordion-button collapsed" data-bs-toggle="collapse" data-bs-target="#item__four" aria-expanded="false" aria-controls="item__four">
                                        Why is domain name registration required?
                                    </h4>
                                </div>
                                <div id="item__four" class="accordion-collapse collapse" aria-labelledby="four" data-bs-parent="#rts-accordion">
                                    <div class="accordion-body">
                                        Above all else, we strive to deliver outstanding customer experiences. When you buy a domain name from hostie, we guarantee it will be handed over.
                                    </div>
                                </div>
                            </div>
                            <div class="accordion-item">
                                <div class="accordion-header" id="five">
                                    <h4 class="accordion-button collapsed" data-bs-toggle="collapse" data-bs-target="#item__five" aria-expanded="false" aria-controls="item__four">
                                        Why is domain name registration required?
                                    </h4>
                                </div>
                                <div id="item__five" class="accordion-collapse collapse" aria-labelledby="five" data-bs-parent="#rts-accordion">
                                    <div class="accordion-body">
                                        Above all else, we strive to deliver outstanding customer experiences. When you buy a domain name from hostie, we guarantee it will be handed over.
                                    </div>
                                </div>
                            </div>

                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>
    <!-- SHARED HOSTING FAQ END -->

    <!-- HOSTIE CTA -->
    <div class="rts-cta-two shared-page-bg">
        <div class="container">
            <div class="row">
                <div class="rts-cta-two__wrapper">
                    <div class="cta__shape"></div>
                    <div class="cta-content">
                        <span data-sal="slide-down" data-sal-delay="100" data-sal-duration="800">Need help choosing a plan?</span>
                        <h4 data-sal="slide-down" data-sal-delay="200" data-sal-duration="800">Need help?
                            We're always here for you.</h4>
                    </div>
                    <div class="cta-btn">
                        <a href="#" class="contact__us primary__btn btn__two secondary__bg secondary__color">Go to Live chat Page</a>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- HOSTIE CTA END -->
   
    <!-- FOOTER AREA START-->
        <?php include 'layout/footer/footer-two.php';?>
    <!-- FOOTER AREA END -->

    <div id="anywhere-home" class=""></div>

    <!-- Sidebar area start -->
        <?php include 'layout/partials/sidebar.php';?>
    <!-- Sidebar area end -->

    <!-- THEME PRELOADER START -->
        <?php include 'layout/partials/preloader.php';?>
    <!-- THEME PRELOADER END -->

    <!-- BACK TO TOP AREA START -->
        <?php include 'layout/partials/back-to-top.php';?>
    <!-- BACK TO TOP AREA EDN -->

    <!-- Scripts -->
        <?php include 'layout/partials/scripts.php';?>

</body>
</html>